#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/signal.h>
#include <math.h>

#define SIZE 8000

static int pass = 0;
static float best = 0.0;
static float worst = 100.0;
static double total = 0.0;
static double delay_total = 0.0;

void hup_handler(int sig)
{
	printf("\n--- Results after %d passes ---\n", pass);
	printf("Best: %.3f -- Worst: %.3f -- Average: %f, Difference: %f\n", 
			best, worst, pass ? total/pass : 100.00, pass ? delay_total/pass : 100);
	exit(0);
}

int main(int argc, char *argv[])
{
	int fd;
	int res;
	int count=0;
	int seconds;
	int curarg = 1;
	int verbose=0;
	char buf[8192];
	float score;
	float ms;
	struct timeval start, now;
	fd = open("/dev/zap/pseudo", O_RDWR);
	if (fd < 0) {
		fprintf(stderr, "Unable to open zap interface: %s\n", strerror(errno));
		exit(1);
	}
	while(curarg < argc) {
		if (!strcasecmp(argv[curarg], "-v"))
			verbose++;
		if (!strcasecmp(argv[curarg], "-c") && argc > curarg)
			seconds = atoi(argv[curarg + 1]);
		curarg++;
	}
	printf("Opened pseudo zap interface, measuring accuracy...\n");
	signal(SIGHUP, hup_handler);
	signal(SIGINT, hup_handler);
	signal(SIGALRM, hup_handler);
	/* Flush input buffer */
	for (count = 0;count < 4; count++)
		res = read(fd, buf, sizeof(buf));
	count = 0;
	if (seconds > 0)
		alarm(seconds + 1);
	for(;;) {
		if (count == 0)
			ms = 0;
		gettimeofday(&start, NULL);
		res = read(fd, buf, sizeof(buf));
		if (res < 0) {
			fprintf(stderr, "Failed to read from pseudo interface: %s\n", strerror(errno));
			exit(1);
		}
		count += res;
		gettimeofday(&now, NULL);
		ms += (now.tv_sec - start.tv_sec) * 8000;
		ms += (now.tv_usec - start.tv_usec) / 125.0;
		if (count >= SIZE) {
			double percent;

			percent = 100.0 * (count - ms) / count;
			if (verbose)
				printf("\n%d zaptel samples in %0.3f system clock sample intervals (%.3f%%)", 
						count, ms, 100 - percent);
			else if ((pass % 8) == 7) printf("\n");
			score = 100.0 - fabs(percent);
			if (score > best)
				best = score;
			if (score < worst)
				worst = score;
			if (!verbose)
				printf("%f%% ", score);
			total += score;
			delay_total += 100 - percent;
			fflush(stdout);
			count = 0;
			pass++;
		}
	}
}
