#ifndef _WCTDM24XXP_H
#define _WCTDM24XXP_H

#include "../zaptel.h"
#include <asm/semaphore.h>

#define NUM_FXO_REGS 60

#define WC_MAX_IFACES 128

/*!
 * \brief Default ringer debounce (in ms)
 *
 * \todo This value differs from that in wctdm.  In that module, it is 64 ms
 *       instead of 128 ms.  Which one is more appropriate?
 */
#define DEFAULT_RING_DEBOUNCE	128
#define DEFAULT_BATT_DEBOUNCE	64		/* Battery debounce (in ms) */
#define POLARITY_DEBOUNCE 64           /* Polarity debounce (in ms) */
#define DEFAULT_BATT_THRESH	3		/* Anything under this is "no battery" */

#define OHT_TIMER		6000	/* How long after RING to retain OHT */

#define FLAG_3215	(1 << 0)

#define EFRAME_SIZE	108
#define ERING_SIZE 16		/* Maximum ring size */
#define EFRAME_GAP 20
#define SFRAME_SIZE ((EFRAME_SIZE * ZT_CHUNKSIZE) + (EFRAME_GAP * (ZT_CHUNKSIZE - 1)))

#define MAX_ALARMS 10

#define MOD_TYPE_NONE		0
#define MOD_TYPE_FXS		1
#define MOD_TYPE_FXO		2
#define MOD_TYPE_FXSINIT	3	
#define MOD_TYPE_VPM		4
#define MOD_TYPE_QRV		5
#define MOD_TYPE_VPM150M	6

#define MINPEGTIME	10 * 8		/* 30 ms peak to peak gets us no more than 100 Hz */
#define PEGTIME		50 * 8		/* 50ms peak to peak gets us rings of 10 Hz or more */
#define PEGCOUNT	5		/* 5 cycles of pegging means RING */

#define SDI_CLK		(0x00010000)
#define SDI_DOUT	(0x00020000)
#define SDI_DREAD	(0x00040000)
#define SDI_DIN		(0x00080000)

#define PCI_WINDOW_SIZE ((2 * 2 * 2 * SFRAME_SIZE) + (2 * ERING_SIZE * 4))

#define __CMD_RD   (1 << 20)		/* Read Operation */
#define __CMD_WR   (1 << 21)		/* Write Operation */
#define __CMD_FIN  (1 << 22)		/* Has finished receive */
#define __CMD_TX   (1 << 23)		/* Has been transmitted */

#define CMD_WR(a,b) (((a) << 8) | (b) | __CMD_WR)
#define CMD_RD(a) (((a) << 8) | __CMD_RD)

#if 0
#define CMD_BYTE(card,bit,altcs) (((((card) & 0x3) * 3 + (bit)) * 7) \
			+ ((card) >> 2) + (altcs) + ((altcs) ? -21 : 0))
#endif
#define NUM_CARDS 24
#define NUM_EC	  4
#define NUM_SLOTS 6
#define MAX_TDM_CHAN 31

#define NUM_CAL_REGS 12

#define USER_COMMANDS 8
#define ISR_COMMANDS  2
#define	QRV_DEBOUNCETIME 20

#define MAX_COMMANDS (USER_COMMANDS + ISR_COMMANDS)

#define __VPM150M_RWPAGE	(1 << 4)
#define __VPM150M_RD		(1 << 3)
#define __VPM150M_WR		(1 << 2)
#define __VPM150M_FIN		(1 << 1)
#define __VPM150M_TX		(1 << 0)

#define VPM150M_HPI_CONTROL 0x00
#define VPM150M_HPI_ADDRESS 0x02
#define VPM150M_HPI_DATA 0x03

#define VPM150M_MAX_COMMANDS 8

/* Some Bit ops for different operations */
#define VPM150M_SPIRESET		0
#define VPM150M_HPIRESET		1
#define VPM150M_SWRESET			2
#define VPM150M_DTMFDETECT		3
#define VPM150M_ACTIVE			4

#define VPM150M_MAX_DATA		3

#define VPM_SUPPORT

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
#define VPM150M_SUPPORT
#endif

#ifdef VPM_SUPPORT

/* Define to get more attention-grabbing but slightly more CPU using echocan status */
#define FANCY_ECHOCAN

#endif

struct vpm150m_cmd {
	unsigned int addr;
	unsigned char datalen;
	unsigned char desc;
	unsigned char txident;
	unsigned short data[VPM150M_MAX_DATA];
};

struct vpm150m {
#ifdef VPM150M_SUPPORT
	struct workqueue_struct *wq;
	struct work_struct work;
#endif
	struct wctdm *wc;

	int dspid;
	struct semaphore sem;
	unsigned long control;
	unsigned char curpage;
	unsigned short version;
	unsigned long curecstate;
	unsigned long desiredecstate;
	unsigned long curdtmfmutestate;
	unsigned long desireddtmfmutestate;
	struct vpm150m_cmd cmdq[MAX_COMMANDS];
	unsigned char curtone[24];
};

struct calregs {
	unsigned char vals[NUM_CAL_REGS];
};

struct cmdq {
	unsigned int cmds[MAX_COMMANDS];
	unsigned char isrshadow[ISR_COMMANDS];
};

struct wctdm {
	struct pci_dev *dev;
	char *variety;
	struct zt_span span;
	unsigned char ios;
	unsigned int sdi;
	int usecount;
	unsigned int intcount;
	unsigned int rxints;
	unsigned int txints;
	unsigned int intmask;
	unsigned char txident;
	unsigned char rxident;
	int dead;
	int pos;
	int flags[NUM_CARDS];
	int freeregion;
	int alt;
	int rdbl;
	int tdbl;
	int curcard;
	unsigned char ctlreg;
	int cards;
	int cardflag;		/* Bit-map of present cards */
 	int altcs[NUM_CARDS + NUM_EC];
	char qrvhook[NUM_CARDS];
	unsigned short qrvdebtime[NUM_CARDS];
	int radmode[NUM_CARDS];
#define	RADMODE_INVERTCOR 1
#define	RADMODE_IGNORECOR 2
#define	RADMODE_EXTTONE 4
#define	RADMODE_EXTINVERT 8
#define	RADMODE_IGNORECT 16
#define	RADMODE_PREEMP	32
#define	RADMODE_DEEMP 64
	unsigned short debouncetime[NUM_CARDS];
	signed short rxgain[NUM_CARDS];
	signed short txgain[NUM_CARDS];
	spinlock_t reglock;
	wait_queue_head_t regq;
	/* FXO Stuff */
	union {
		struct {
			int wasringing;
			int ringdebounce;
			int offhook;
			int battdebounce;
			int nobatttimer;
			int battery;
			int lastpol;
			int polarity;
			int polaritydebounce;
		} fxo;
		struct {
			int oldrxhook;
			int debouncehook;
			int lastrxhook;
			int debounce;
			int ohttimer;
			int idletxhookstate;		/* IDLE changing hook state */
			int lasttxhook;
			int palarms;
			struct calregs calregs;
		} fxs;
	} mods[NUM_CARDS];
	struct cmdq cmdq[NUM_CARDS + NUM_EC];
	/* Receive hook state and debouncing */
	int modtype[NUM_CARDS + NUM_EC];
	/* Set hook */
	int sethook[NUM_CARDS + NUM_EC];
 	int dacssrc[NUM_CARDS];
 	int type;

#ifdef VPM_SUPPORT
	int vpm;
	unsigned long dtmfactive;
	unsigned long dtmfmask;
	unsigned long dtmfmutemask;
	short dtmfenergy[NUM_CARDS];
	short dtmfdigit[NUM_CARDS];

	struct  vpm150m *vpm150m;
#ifdef FANCY_ECHOCAN
	int echocanpos;
	int blinktimer;
#endif	
#endif
	unsigned long iobase;
	dma_addr_t 	readdma;
	dma_addr_t	writedma;
	dma_addr_t  descripdma;
	volatile unsigned int *writechunk;					/* Double-word aligned write memory */
	volatile unsigned int *readchunk;					/* Double-word aligned read memory */
	volatile unsigned int *descripchunk;					/* Descriptors */
	struct zt_chan chans[NUM_CARDS];
};


int schluffen(wait_queue_head_t *q);

extern spinlock_t ifacelock;
extern struct wctdm *ifaces[WC_MAX_IFACES];

#endif
